Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[caves.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission3.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
		PointGainPerCapture = 3.0,
		
		--HiveLifecycleK      = 6.0,
		CaptureRateK        = 0.3
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false, 		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = true,         --Do captures halve defensive strength?
		DisableLockdown = true,         --Turn off emergency help is player is behind
		NoAdvance       = false,        --Do not allow player to capture points
		HiveCtrAttack   = false,        --Send alien spawn to undefended alien hives
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	GetLevelProgress = function ()

        return num_captures / captures_to_win
		
	end,
	
	OnDebugCall = function (mousePos)

        --CreateConvoy(3)
	    --SniperDrop:Enable()
		
        local convoy = CreateConvoy(4)
        convoy[1]:SetWeaponType(WeaponType.WT_SNIPERRIFLE)
		
	end,
}

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		UpdateCrateCount()
		CaptureCratesObjective:Enable()
		
		self:Disable()
	end)
LevelInit:Enable()

------------------------------------------------------------------------------- Tracked objective for capturing crates
CaptureCratesObjective = {}

function CaptureCratesObjective:Enable()
    GameWorld:AddObjective("winObj", "Escort " .. captures_to_win .. " crates to safety")
    GameWorld:AddObjective("bpObj", "Escort crates to get BP")
    
    local text_hdl = GameWorld:ShowText("Commander, the convoy will be coming soon.\n\nClear the area from aliens and protect the crates!", "Scout")
    ScriptMgr:DoDelayedCall(16000, function () text_hdl:ClearText(); end)	
end

function CaptureCratesObjective:Disable()
    GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
    GameWorld:ChangeObjectiveStatus("bpObj", [[complete]])
    GameWorld:GameOver(true)
end


samplePathMarkerHdl = nil
box_handles = {}
marine_handle_map = {}

function CreateConvoy(p_marineCount)

    local resultList = {}
    local nSpawn = p_marineCount
    for i=1,nSpawn do
        local deltaV = vect2f.MakePolar(GetRandomRangeInt(3.0, 4.0), i/nSpawn*math.pi*2)
        local marineEnt = nil
        local crateEnt = nil
        
        marineEnt, crateEnt = CreateConvoyMarineWithCrate(deltaV)
        
        table.insert(resultList, marineEnt:ToCHuman())
        marine_handle_map[crateEnt:GetId()] = EHandle(marineEnt)
        
        local crateHandle = EHandle(crateEnt)
        table.insert(box_handles, crateHandle)
    end

    if samplePathMarkerHdl then
        local ent = samplePathMarkerHdl:GetPtr()
        ent:Kill()
    end
    
    local waypointVects = {}
    local nWaypoints = #convoyPath[currentConvoyPath]
    for i=1,nWaypoints do
        local waypoint = GameWorld:GetEntityById(convoyPath[currentConvoyPath][i]);

        if waypoint then
            table.insert(waypointVects, waypoint:GetPos())
        end
    end
    
    samplePathMarkerHdl = GameWorld:CreatePathMarker(waypointVects):GetHandle()  

    return resultList	

end

currentConvoyPath = 1
convoyPath = {}
convoyPath[1] = {"waypoint_0", "waypoint_1", "waypoint_2", "waypoint_3", "waypoint_4", "waypoint_5", "waypoint_6", "waypoint_7"} 
convoyPath[2] = {"waypoint_6", "waypoint_5", "waypoint_4", "waypoint_3", "waypointB_1", "waypointB_2", "waypointB_3", "waypointB_4"} 

function CreateConvoyMarineWithCrate(p_offset)

    local startEnt = GameWorld:GetEntityById(convoyPath[currentConvoyPath][1]);

    local marine = GameWorld:CreateEntity("AIMarine", "", startEnt:GetPos() + p_offset)
    marine:SetPoisonResistance(10000)
    marine:SetSpeedMultiple(2.0)
    local crate = GameWorld:CreateEntity("PropCrate", "", startEnt:GetPos() + vect2f(1,0))
    
    crate:AttachTo(marine)
    
    local nWaypoints = #convoyPath[currentConvoyPath]
    for i=1,nWaypoints do
        local waypoint = GameWorld:GetEntityById(convoyPath[currentConvoyPath][i]);

        if waypoint then
            marine:SendCommand(ICommandable.CT_ATTACKMOVE, waypoint:GetPos() + p_offset, nil, true)
        end
    end

    return marine, crate

end

function filter_inplace(t, predicate)
    local j = 1
     
    for i = 1,#t do
        local v = t[i]
        if predicate(v) then
            t[j] = v
            j = j + 1
        end
    end
     
    while t[j] ~= nil do
        t[j] = nil
        j = j + 1
    end
     
    return t
end

function CheckAreaForBoxes(p_areaId, p_givePoints)

    filter_inplace(box_handles, function(p_handle) return p_handle:GetPtr() ~= nil end)

	local targetArea = GameWorld:GetEntityById(p_areaId);

	if not targetArea then
		return false
	end	
	
	for i=1, #box_handles do
		local crate = box_handles[i]:GetPtr();
		
		if crate then
		    local marineHdl = marine_handle_map[crate:GetId()]
		    local marine = nil
		    
		    if marineHdl then
		        marine = marineHdl:GetPtr()
		    end
		
            if (targetArea:GetPos() - crate:GetPos()):LengthSq() < targetArea:GetRadius()*targetArea:GetRadius() then
                crate:Kill()
                
                if p_givePoints then
                    OnBoxCaptured()
                end
                
                if marine then
                    marine:Kill()
                end
            end
		end
	end	

	return false
end

function OnUpdate(p_milliseconds)

    --CheckAreaForBoxes(convoyPath[currentConvoyPath][#convoyPath[currentConvoyPath]])
	CheckAreaForBoxes("waypointB_4", currentConvoyPath == 2)
	CheckAreaForBoxes("waypoint_7", currentConvoyPath == 1)

end
ScriptMgr:SetUpdateCallback(OnUpdate)

captures_to_win = 14
num_captures = 0
mutation_table = {}
--mutation_table[1] = "ZU_TAKEOVER_SPECIAL"
mutation_table[5] = "ZU_ZOMBIE_MINES"
mutation_table[8] = "ZU_RUST"
mutation_table[3] = "ZU_BOMBARDMENT"
mutation_table[9] = "ZU_HARDPOINT"
--mutation_table[6] = ""
--mutation_table[5] = "ZU_SLOWING_POISON"
mutation_table[6] = "ZU_SPIKE_POWER"

function UpdateCrateCount()
    GameWorld:SetUIElementText("RewardCounter", num_captures .. "/" .. captures_to_win .. " Crates")	
end


function OnBoxCaptured()
    GameWorld:ChangeBuildPoints(3)
    
    num_captures = num_captures + 1
    
    local current_mutation = mutation_table[num_captures]
    if current_mutation then
        GameWorld:ActivateMutation(current_mutation, true)
    end
    
    if num_captures == 3 then
        SniperDrop:Enable()
    end
    
    if num_captures == 9 then
        currentConvoyPath = 2
    end
    
    GameWorld:SetSpawnRate(math.min(30.0, num_captures * 3.0))
    GameWorld:SetSpawnRateScalingOn(false)
    
    UpdateCrateCount()
    
    if num_captures == captures_to_win then
        CaptureCratesObjective:Disable()
    end
    
    local text_hdl = nil
    if num_captures == 3 then
        text_hdl = GameWorld:ShowText("The spit towers are growing more powerful.\n\nCommander, I'm sending you a sniper to counter this new mutation.", "Scout")
    elseif num_captures == 6 then
        text_hdl = GameWorld:ShowText("Uh, the General has no idea that we're out here, does he Cass?", "Sarge")       
    elseif num_captures == 9 then
        text_hdl = GameWorld:ShowText("Damn, the cave to the right is too small.\n\nWe will move some of the crates to the other cave.", "Scout")
    end
    
    if text_hdl then
        ScriptMgr:DoDelayedCall(16000, function () text_hdl:ClearText(); end)	
    end
    
end

lastSniperEnt = nil
lastMedicEnt = nil
function StartConvoyTimer()
    currentTimer = LevelUtils.CreateTimer(30000, "Convoy in %s",
        function()
        
            if num_captures >= 9 then
                 local convoy = CreateConvoy(5)
                 
                 if not lastSniperEnt or not lastSniperEnt:GetPtr() then
                    lastSniperEnt = convoy[1]:GetHandle()
                    convoy[1]:SetWeaponType(WeaponType.WT_SNIPERRIFLE)
                 end
 
                 if not lastMedicEnt or not lastMedicEnt:GetPtr() then
                    lastMedicEnt = convoy[2]:GetHandle()
                    convoy[2]:SetWeaponType(WeaponType.WT_MEDIC)
                 end
                
            else
                 CreateConvoy(3)
            end           
            
            currentTimer:Disable()
            GameWorld:SetEventIndicator("Protect The Convoy")
            ScriptMgr:DoDelayedCall(30000, StartConvoyTimer)
        end)
end
StartConvoyTimer()

------------------------------------------------------------------------------- Sniper Delivery (extra soldier)
SniperDrop = LevelUtils.MakeGoal(
	function (self)
		local dropArea = GameWorld:GetEntityById("sniperDropArea");
		if dropArea then
			GameWorld:DoChopperDelivery(dropArea:GetPos(), "SniperDrop")
		end	
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "SniperDrop" then
			return
		end
		
		local marine = GameWorld:CreateEntity("Marine", "", p_pos + vect2f(2.0,0)):ToCHuman()
		GameWorld:AddMarineToSquad(marine)
		marine:SetWeaponType(WeaponType.WT_SNIPERRIFLE)
		marine:SetIsCrateWeapon(true)
		
		local marine = GameWorld:CreateEntity("Marine", "", p_pos + vect2f(-2.0,0)):ToCHuman()
		GameWorld:AddMarineToSquad(marine)
		marine:SetWeaponType(WeaponType.WT_MEDIC)
		marine:SetIsCrateWeapon(true)
		
		self:Disable()
	end)

------------------------------------------------------------------------------- Extra Win Achievement
LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_GAME_OVER]]},
	function (self, p_type, p_entId, p_pos, p_other)
        if p_other == "win" then
		    if GameWorld:GetStat([[ST_GAMETIME]]) <= 10*60*1000 then
		        SteamAchievements:SetAchievement("BEAT_PREPARATIONS_EXTRA_TIME")
		    end    
		end	
	end):Enable()
		
		
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()

------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		CaptureAllGoal:Disable()
	
		self:Disable()
	end)
LossCondition:Enable()
	